/*
 * Uplink (GoldenEye: Source Gameplay) Helper
 * ----
 * (C) 2011 badplayer
 *
 * Usage:
 *  GEUtil.EmitGameplayEvent("up_plugin_spawn", flag entity #, ring radius, start color)
 *  GEUtil.EmitGameplayEvent("up_plugin_update", flag entity #, new color)
 *  GEUtil.EmitGameplayEvent("up_plugin_kill", flag entity #)
 *
 * Known limitations:
 * - max 16 flags
 * - python gameplay filename stored in PYFILENAME, it isn't case sensitive
 * - ring color takes the following values: 0 (yellow DM), 1 (blue MI6), 2 (red Janus), or 3 (white Neutral)
 *
 * Thank you to:
 *  Euhponic for creating such a great gameplay
 *  KM for his awesome help
 *
 * ----
 * As required by Sourcemod's license:
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3.0, as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma semicolon 1
#include <sourcemod>
#include <sdktools>

#define NAME "Uplink Helper"
#define PLUGIN_VERSION "0.21"
#define PYFILENAME "Uplink"
//#define DEBUG

new g_iMatLaser = -1;
new g_iMatHalo = -1;
new Handle:hTETimer = INVALID_HANDLE;
new const g_vColorNeutral[4] = { 255, 255, 255, 200 };
new const g_vColorDM[4] = { 244, 192, 11, 200 };
new const g_vColorMI6[4] = { 14, 139, 237, 200 };
new const g_vColorJanus[4] = { 224, 18, 18, 200 };

// Could use adt_array's instead
new g_iEntIndex[16] = { 0, 0, ... };
new Float:g_vEntPosition[16][3];
new Float:g_flEntRadius[16];
new g_vEntColor[16][4];

public Plugin:myinfo =
{
	name = NAME,
	author = "badplayer",
	description = NAME,
	version = PLUGIN_VERSION,
	url = "http://www.ges-stats.com"
};

public OnPluginStart()
{
	CreateConVar("uplinkhelper_version", PLUGIN_VERSION, NAME, FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	HookEvent("gamemode_change", EventGameplayChange);
	HookEvent("gameplay_event", EventGameplayAction);
}

public OnMapStart()
{
	g_iMatLaser = PrecacheModel("materials/sprites/laser.vmt");
	g_iMatHalo = PrecacheModel("materials/sprites/halo01.vmt");
}

public OnMapEnd()
{
	hTETimer = INVALID_HANDLE;
}

public EventGameplayChange(Handle:event, const String:name[], bool:dontBroadcast)
{
	decl String:sGameplay[32];
	GetEventString(event, "ident", sGameplay, sizeof(sGameplay));

	if(
		StrEqual(sGameplay, PYFILENAME, false) &&
		g_iMatLaser != -1 &&
		g_iMatHalo != -1 &&
		hTETimer == INVALID_HANDLE
	)
	{
		hTETimer = CreateTimer(0.6, TimerRingPoint, _, TIMER_REPEAT|TIMER_FLAG_NO_MAPCHANGE);
	}
	else if(
		!StrEqual(sGameplay, PYFILENAME, false) &&
		hTETimer != INVALID_HANDLE
	)
	{
		KillTimer(hTETimer);
		hTETimer = INVALID_HANDLE;
	}
}

public Action:TimerRingPoint(Handle:timer)
{
	for(new i = 0; i < 16; i++)
	{
		if( g_iEntIndex[i] != 0 )
		{
			// http://docs.sourcemod.net/api/index.php?fastload=show&id=383
			// Could use FBEAM_FOREVER flag, though can't find a way to remove TE using that
			TE_SetupBeamRingPoint(
				g_vEntPosition[i],		// Center position of the ring.
				g_flEntRadius[i],		// Initial ring radius.
				g_flEntRadius[i] + 0.1,	// Final ring radius.
				g_iMatLaser,				// Precached model index.
				g_iMatHalo,				// Precached model index.
				0,							// Initital frame to render.
				15,							// Ring frame rate.
				0.6,						// Time duration of the ring.
				3.0,						// Beam width.
				0.0,						// Beam amplitude.
				g_vEntColor[i],			// Color array (r, g, b, a).
				1,							// Speed of the beam.
				0);							// Beam flags.
			TE_SendToAll();
		}
	}
	//#if defined DEBUG
	//LogError("Timer executed.");
	//#endif
}

public EventGameplayAction(Handle:event, const String:name[], bool:dontBroadcast)
{
	decl String:sGameplay[32], String:sActionType[18];
	GetEventString(event, "ident", sGameplay, sizeof(sGameplay));
	GetEventString(event, "name", sActionType, sizeof(sActionType));
	new iZoneIndex = GetEventInt(event, "value1");

	if(
		StrEqual(sGameplay, PYFILENAME, false) &&
		StrEqual(sActionType, "up_plugin_spawn", false)
	)
	{
		new j = -1; // Next available index
		for(new i = 0; i < 16; i++)
		{
			if( g_iEntIndex[i] == 0 )
			{
				j = i;
				break;
			}
		}

		if(j != -1)
		{
			// Index
			g_iEntIndex[j] = iZoneIndex;

			// Position
			GetEntPropVector(iZoneIndex, Prop_Send, "m_vecOrigin", g_vEntPosition[j]);
			g_vEntPosition[j][2] -= 10.0; // Could also use Trace to detect ground

			// Radius
			g_flEntRadius[j] = GetEventFloat(event, "value2") * 2;

			// Color
			new iColor = GetEventInt(event, "value3");
			switch(iColor)
			{
				case 0: g_vEntColor[j] = g_vColorDM;
				case 1: g_vEntColor[j] = g_vColorMI6;
				case 2: g_vEntColor[j] = g_vColorJanus;
				case 3: g_vEntColor[j] = g_vColorNeutral;
			}

			// Misc
			SetEntPropFloat(iZoneIndex, Prop_Send, "m_GlowDist", 3500.0);

			#if defined DEBUG
			LogError("(%i) beam #%i, position %f %f %f.", j, iZoneIndex, g_vEntPosition[j][0], g_vEntPosition[j][1], g_vEntPosition[j][2]);
			#endif
		}
		#if defined DEBUG
		else
		{
			LogError("No index left.");
		}
		#endif
	}
	else if(
		StrEqual(sGameplay, PYFILENAME, false) &&
		StrEqual(sActionType, "up_plugin_update", false)
	)
	{
		for(new i = 0; i < 16; i++)
		{
			if( iZoneIndex == g_iEntIndex[i] )
			{
				new iColor = GetEventInt(event, "value2");

				// Ring color
				switch(iColor)
				{
					case 0: g_vEntColor[i] = g_vColorDM;
					case 1: g_vEntColor[i] = g_vColorMI6;
					case 2: g_vEntColor[i] = g_vColorJanus;
					case 3: g_vEntColor[i] = g_vColorNeutral;
				}

				// Token color
				ChangeTokenColor(iZoneIndex, iColor, g_vEntColor[i]);

				#if defined DEBUG
				LogError("(%i) updated %i with color %i", i, iZoneIndex, iColor);
				#endif
			}
		}
	}
	else if(
		StrEqual(sGameplay, PYFILENAME, false) &&
		StrEqual(sActionType, "up_plugin_kill", false)
	)
	{
		for(new i = 0; i < 16; i++)
		{
			if( iZoneIndex == g_iEntIndex[i] )
			{
				g_iEntIndex[i] = 0;
				//g_vEntPosition[i] = { 0.0, 0.0, 0.0 };
				g_flEntRadius[i] = 0.0;
				g_vEntColor[i] = { 0, 0, 0, 0 };
				#if defined DEBUG
				LogError("(%i) removed %i", i, iZoneIndex);
				#endif
			}
		}
	}
}

stock ChangeTokenColor(iEntity, iSkinValue, vColor[4])
{
	// Glow
	new iColorBuffer = vColor[0] | vColor[1] << 8 | vColor[2] << 16 | vColor[3] << 24;
	SetEntProp(iEntity, Prop_Send, "m_GlowColor", iColorBuffer);

	// Model
	if(iSkinValue == 3)
	{
		iSkinValue = 0;
	}
	decl String:sSkinBuffer[2];
	IntToString(iSkinValue, sSkinBuffer, sizeof(sSkinBuffer));
	DispatchKeyValue(iEntity, "skin", sSkinBuffer);
}